/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.fakes.InventoryBearerInterface;
import carpet.script.CarpetContext;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.utils.EquipmentInventory;
import carpet.script.value.BlockValue;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ScreenValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2203;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2290;
import net.minecraft.class_2291;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3954;
import net.minecraft.class_6067;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

public class NBTSerializableValue
extends Value
implements ContainerValueInterface {
    private String nbtString = null;
    private class_2520 nbtTag = null;
    private Supplier<class_2520> nbtSupplier = null;
    private boolean owned = false;
    private static final Map<String, class_2290> itemCache = new HashMap<String, class_2290>();
    private static Map<String, class_2203.class_2209> pathCache = new HashMap<String, class_2203.class_2209>();

    private NBTSerializableValue() {
    }

    public NBTSerializableValue(String nbtString) {
        this.nbtSupplier = () -> {
            try {
                return new class_2522(new StringReader(nbtString)).method_10723();
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException("Incorrect NBT data: " + nbtString);
            }
        };
        this.owned = true;
    }

    public NBTSerializableValue(class_2520 tag) {
        this.nbtTag = tag;
        this.owned = true;
    }

    public static Value of(class_2520 tag) {
        if (tag == null) {
            return Value.NULL;
        }
        return new NBTSerializableValue(tag);
    }

    public NBTSerializableValue(Supplier<class_2520> tagSupplier) {
        this.nbtSupplier = tagSupplier;
    }

    public static Value fromStack(class_1799 stack) {
        if (stack.method_7985()) {
            NBTSerializableValue value = new NBTSerializableValue();
            value.nbtSupplier = () -> ((class_1799)stack).method_7969();
            return value;
        }
        return Value.NULL;
    }

    public static String nameFromRegistryId(class_2960 id) {
        if (id == null) {
            return "";
        }
        if (id.method_12836().equals("minecraft")) {
            return id.method_12832();
        }
        return id.toString();
    }

    public static NBTSerializableValue parseString(String nbtString, boolean fail) {
        class_2520 tag;
        try {
            tag = new class_2522(new StringReader(nbtString)).method_10723();
        }
        catch (CommandSyntaxException e) {
            if (fail) {
                throw new InternalExpressionException("Incorrect NBT tag: " + nbtString);
            }
            return null;
        }
        NBTSerializableValue value = new NBTSerializableValue(tag);
        value.nbtString = null;
        return value;
    }

    public Value clone() {
        NBTSerializableValue copy = new NBTSerializableValue(this.nbtTag);
        copy.nbtSupplier = this.nbtSupplier;
        copy.nbtString = this.nbtString;
        copy.owned = this.owned;
        return copy;
    }

    @Override
    public Value deepcopy() {
        NBTSerializableValue copy = (NBTSerializableValue)this.clone();
        copy.owned = false;
        this.ensureOwnership();
        return copy;
    }

    @Override
    public Value fromConstant() {
        return this.deepcopy();
    }

    public static class_1263 getInventoryAt(class_3218 world, class_2338 blockPos) {
        List list;
        class_2586 blockEntity;
        class_1278 inventory = null;
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            inventory = ((class_3954)block).method_17680(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_31709() && (blockEntity = BlockValue.getBlockEntity(world, blockPos)) instanceof class_1263 && (inventory = (class_1263)blockEntity) instanceof class_2595 && block instanceof class_2281) {
            inventory = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        if (inventory == null && !(list = world.method_8333((class_1297)null, new class_238((double)blockPos.method_10263() - 0.5, (double)blockPos.method_10264() - 0.5, (double)blockPos.method_10260() - 0.5, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5), class_1301.field_6152)).isEmpty()) {
            inventory = (class_1263)list.get(world.field_9229.method_43048(list.size()));
        }
        return inventory;
    }

    public static InventoryLocator locateInventory(CarpetContext c, List<Value> params, int offset) {
        try {
            Value v1 = params.get(offset);
            if (v1.isNull()) {
                v1 = params.get(++offset);
            } else if (v1 instanceof StringValue) {
                class_3222 player;
                String strVal = v1.getString().toLowerCase(Locale.ROOT);
                if (strVal.equals("enderchest")) {
                    Value v2 = params.get(1 + offset);
                    class_3222 player2 = EntityValue.getPlayerByValue(c.s.method_9211(), v2);
                    if (player2 == null) {
                        throw new InternalExpressionException("enderchest inventory requires player argument");
                    }
                    return new InventoryLocator(player2, player2.method_24515(), (class_1263)player2.method_7274(), offset + 2, true);
                }
                if (strVal.equals("equipment")) {
                    Value v2 = params.get(1 + offset);
                    if (!(v2 instanceof EntityValue)) {
                        throw new InternalExpressionException("Equipment inventory requires a living entity argument");
                    }
                    class_1297 e = ((EntityValue)v2).getEntity();
                    if (!(e instanceof class_1309)) {
                        throw new InternalExpressionException("Equipment inventory requires a living entity argument");
                    }
                    return new InventoryLocator(e, e.method_24515(), new EquipmentInventory((class_1309)e), offset + 2);
                }
                boolean isEnder = strVal.startsWith("enderchest_");
                if (isEnder) {
                    strVal = strVal.substring(11);
                }
                if ((player = c.s.method_9211().method_3760().method_14566(strVal)) == null) {
                    throw new InternalExpressionException("String description of an inventory should either denote a player or player's enderchest");
                }
                return new InventoryLocator(player, player.method_24515(), (class_1263)(isEnder ? player.method_7274() : player.method_31548()), offset + 1, isEnder);
            }
            if (v1 instanceof EntityValue) {
                class_1661 inv = null;
                class_1297 e = ((EntityValue)v1).getEntity();
                if (e instanceof class_1657) {
                    class_1657 pe = (class_1657)e;
                    inv = pe.method_31548();
                } else if (e instanceof class_1263) {
                    inv = (class_1263)e;
                } else if (e instanceof class_6067) {
                    class_6067 io = (class_6067)e;
                    inv = io.method_35199();
                } else if (e instanceof InventoryBearerInterface) {
                    InventoryBearerInterface ibi = (InventoryBearerInterface)e;
                    inv = ibi.getCMInventory();
                } else if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    return new InventoryLocator(e, e.method_24515(), new EquipmentInventory(le), offset + 1);
                }
                if (inv == null) {
                    return null;
                }
                return new InventoryLocator(e, e.method_24515(), (class_1263)inv, offset + 1);
            }
            if (v1 instanceof BlockValue) {
                class_2338 pos = ((BlockValue)v1).getPos();
                if (pos == null) {
                    throw new InternalExpressionException("Block to access inventory needs to be positioned in the world");
                }
                class_1263 inv = NBTSerializableValue.getInventoryAt(c.s.method_9225(), pos);
                if (inv == null) {
                    return null;
                }
                return new InventoryLocator(pos, pos, inv, offset + 1);
            }
            if (v1 instanceof ListValue) {
                List<Value> args = ((ListValue)v1).getItems();
                class_2338 pos = new class_2338(NumericValue.asNumber(args.get(0)).getDouble(), NumericValue.asNumber(args.get(1)).getDouble(), NumericValue.asNumber(args.get(2)).getDouble());
                class_1263 inv = NBTSerializableValue.getInventoryAt(c.s.method_9225(), pos);
                if (inv == null) {
                    return null;
                }
                return new InventoryLocator(pos, pos, inv, offset + 1);
            }
            if (v1 instanceof ScreenValue) {
                ScreenValue screenValue = (ScreenValue)v1;
                if (!screenValue.isOpen()) {
                    return null;
                }
                return new InventoryLocator(screenValue.getPlayer(), screenValue.getPlayer().method_24515(), screenValue.getInventory(), offset + 1);
            }
            class_2338 pos = new class_2338(NumericValue.asNumber(v1).getDouble(), NumericValue.asNumber(params.get(1 + offset)).getDouble(), NumericValue.asNumber(params.get(2 + offset)).getDouble());
            class_1263 inv = NBTSerializableValue.getInventoryAt(c.s.method_9225(), pos);
            if (inv == null) {
                return null;
            }
            return new InventoryLocator(pos, pos, inv, offset + 3);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InternalExpressionException("Inventory should be defined either by three coordinates, a block value, an entity, or a screen");
        }
    }

    public static class_2290 parseItem(String itemString) {
        return NBTSerializableValue.parseItem(itemString, null);
    }

    public static class_2290 parseItem(String itemString, class_2487 customTag) {
        try {
            class_2290 res = itemCache.get(itemString);
            if (res != null) {
                if (customTag == null) {
                    return res;
                }
                return new class_2290(class_6880.method_40223((Object)res.method_9785()), customTag);
            }
            class_2291.class_7215 parser = class_2291.method_41972((class_7225)class_7225.method_42018((class_2378)class_2378.field_11142), (StringReader)new StringReader(itemString));
            res = new class_2290(parser.comp_628(), parser.comp_629());
            itemCache.put(itemString, res);
            if (itemCache.size() > 64000) {
                itemCache.clear();
            }
            if (customTag == null) {
                return res;
            }
            return new class_2290(class_6880.method_40223((Object)res.method_9785()), customTag);
        }
        catch (CommandSyntaxException e) {
            throw new ThrowStatement(itemString, Throwables.UNKNOWN_ITEM);
        }
    }

    public static int validateSlot(int slot, class_1263 inv) {
        int invSize = inv.method_5439();
        if (slot < 0) {
            slot = invSize + slot;
        }
        if (slot < 0 || slot >= invSize) {
            return inv.method_5439();
        }
        return slot;
    }

    private static Value decodeSimpleTag(class_2520 t) {
        if (t instanceof class_2514) {
            if (t instanceof class_2503 || t instanceof class_2497) {
                return NumericValue.of(((class_2514)t).method_10699());
            }
            return NumericValue.of(((class_2514)t).method_10702());
        }
        if (t instanceof class_2519) {
            return StringValue.of(t.method_10714());
        }
        if (t instanceof class_2491) {
            return Value.NULL;
        }
        throw new InternalExpressionException("How did we get here: Unknown nbt element class: " + t.method_23258().method_23259());
    }

    private static Value decodeTag(class_2520 t) {
        if (t instanceof class_2487 || t instanceof class_2483) {
            return new NBTSerializableValue(() -> t);
        }
        return NBTSerializableValue.decodeSimpleTag(t);
    }

    private static Value decodeTagDeep(class_2520 t) {
        if (t instanceof class_2487) {
            HashMap<Value, Value> pairs = new HashMap<Value, Value>();
            class_2487 ctag = (class_2487)t;
            for (String key : ctag.method_10541()) {
                pairs.put(new StringValue(key), NBTSerializableValue.decodeTagDeep(ctag.method_10580(key)));
            }
            return MapValue.wrap(pairs);
        }
        if (t instanceof class_2483) {
            ArrayList<Value> elems = new ArrayList<Value>();
            class_2483 ltag = (class_2483)t;
            for (class_2520 elem : ltag) {
                elems.add(NBTSerializableValue.decodeTagDeep(elem));
            }
            return ListValue.wrap(elems);
        }
        return NBTSerializableValue.decodeSimpleTag(t);
    }

    public Value toValue() {
        return NBTSerializableValue.decodeTagDeep(this.getTag());
    }

    public static Value fromValue(Value v) {
        if (v instanceof NBTSerializableValue) {
            return v;
        }
        if (v.isNull()) {
            return Value.NULL;
        }
        return NBTSerializableValue.parseString(v.getString(), true);
    }

    public class_2520 getTag() {
        if (this.nbtTag == null) {
            this.nbtTag = this.nbtSupplier.get();
        }
        return this.nbtTag;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof NBTSerializableValue) {
            return this.getTag().equals(((NBTSerializableValue)o).getTag());
        }
        return super.equals(o);
    }

    @Override
    public String getString() {
        if (this.nbtString == null) {
            this.nbtString = this.getTag().toString();
        }
        return this.nbtString;
    }

    @Override
    public boolean getBoolean() {
        class_2520 tag = this.getTag();
        if (tag instanceof class_2487) {
            return !((class_2487)tag).method_33133();
        }
        if (tag instanceof class_2483) {
            return !((class_2483)tag).isEmpty();
        }
        if (tag instanceof class_2514) {
            return ((class_2514)tag).method_10697() != 0.0;
        }
        if (tag instanceof class_2519) {
            return !tag.method_10714().isEmpty();
        }
        return true;
    }

    public class_2487 getCompoundTag() {
        try {
            this.ensureOwnership();
            return (class_2487)this.getTag();
        }
        catch (ClassCastException e) {
            throw new InternalExpressionException(this.getString() + " is not a valid compound tag");
        }
    }

    @Override
    public boolean put(Value where, Value value) {
        return this.put(where, value, new StringValue("replace"));
    }

    @Override
    public boolean put(Value where, Value value, Value conditions) {
        boolean modifiedTag;
        class_2520 tagToInsert;
        this.ensureOwnership();
        class_2203.class_2209 path = NBTSerializableValue.cachePath(where.getString());
        class_2520 class_25202 = tagToInsert = value instanceof NBTSerializableValue ? ((NBTSerializableValue)value).getTag() : new NBTSerializableValue(value.getString()).getTag();
        if (conditions instanceof NumericValue) {
            modifiedTag = this.modify_insert((int)((NumericValue)conditions).getLong(), path, tagToInsert);
        } else {
            String ops = conditions.getString();
            if (ops.equalsIgnoreCase("merge")) {
                modifiedTag = this.modify_merge(path, tagToInsert);
            } else if (ops.equalsIgnoreCase("replace")) {
                modifiedTag = this.modify_replace(path, tagToInsert);
            } else {
                return false;
            }
        }
        if (modifiedTag) {
            this.dirty();
        }
        return modifiedTag;
    }

    private boolean modify_insert(int index, class_2203.class_2209 nbtPath, class_2520 newElement) {
        return this.modify_insert(index, nbtPath, newElement, this.getTag());
    }

    private boolean modify_insert(int index, class_2203.class_2209 nbtPath, class_2520 newElement, class_2520 currentTag) {
        List targets;
        try {
            targets = nbtPath.method_9367(currentTag, class_2499::new);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        boolean modified = false;
        for (class_2520 target : targets) {
            if (!(target instanceof class_2483)) continue;
            try {
                class_2483 targetList = (class_2483)target;
                if (!targetList.method_10533(index < 0 ? targetList.size() + index + 1 : index, newElement.method_10707())) {
                    return false;
                }
                modified = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return modified;
    }

    private boolean modify_merge(class_2203.class_2209 nbtPath, class_2520 replacement) {
        if (!(replacement instanceof class_2487)) {
            return false;
        }
        class_2520 ownTag = this.getTag();
        try {
            for (class_2520 target : nbtPath.method_9367(ownTag, class_2487::new)) {
                if (!(target instanceof class_2487)) continue;
                ((class_2487)target).method_10543((class_2487)replacement);
            }
        }
        catch (CommandSyntaxException ignored) {
            return false;
        }
        return true;
    }

    private boolean modify_replace(class_2203.class_2209 nbtPath, class_2520 replacement) {
        class_2520 tag = this.getTag();
        String pathText = nbtPath.toString();
        if (pathText.endsWith("]")) {
            int pos;
            if (nbtPath.method_9372(tag) == 0) {
                return false;
            }
            Pattern pattern = Pattern.compile("\\[[^\\[]*]$");
            Matcher matcher = pattern.matcher(pathText);
            if (!matcher.find()) {
                return false;
            }
            String arrAccess = matcher.group();
            if (arrAccess.length() == 2) {
                pos = 0;
            } else {
                try {
                    pos = Integer.parseInt(arrAccess.substring(1, arrAccess.length() - 1));
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            class_2203.class_2209 newPath = NBTSerializableValue.cachePath(pathText.substring(0, pathText.length() - arrAccess.length()));
            return this.modify_insert(pos, newPath, replacement, tag);
        }
        try {
            nbtPath.method_9368(tag, () -> replacement);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public Value get(Value value) {
        String valString = value.getString();
        class_2203.class_2209 path = NBTSerializableValue.cachePath(valString);
        try {
            List tags = path.method_9366(this.getTag());
            if (tags.size() == 0) {
                return Value.NULL;
            }
            if (tags.size() == 1 && !valString.endsWith("[]")) {
                return NBTSerializableValue.decodeTag((class_2520)tags.get(0));
            }
            return ListValue.wrap(tags.stream().map(NBTSerializableValue::decodeTag).collect(Collectors.toList()));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return Value.NULL;
        }
    }

    @Override
    public boolean has(Value where) {
        return NBTSerializableValue.cachePath(where.getString()).method_9374(this.getTag()) > 0;
    }

    private void ensureOwnership() {
        if (!this.owned) {
            this.nbtTag = this.getTag().method_10707();
            this.nbtString = null;
            this.nbtSupplier = null;
            this.owned = true;
        }
    }

    private void dirty() {
        this.nbtString = null;
    }

    @Override
    public boolean delete(Value where) {
        class_2203.class_2209 path = NBTSerializableValue.cachePath(where.getString());
        this.ensureOwnership();
        int removed = path.method_9372(this.getTag());
        if (removed > 0) {
            this.dirty();
            return true;
        }
        return false;
    }

    private static class_2203.class_2209 cachePath(String arg) {
        class_2203.class_2209 res = pathCache.get(arg);
        if (res != null) {
            return res;
        }
        try {
            res = class_2203.method_9360().method_9362(new StringReader(arg));
        }
        catch (CommandSyntaxException exc) {
            throw new InternalExpressionException("Incorrect nbt path: " + arg);
        }
        if (pathCache.size() > 1024) {
            pathCache.clear();
        }
        pathCache.put(arg, res);
        return res;
    }

    @Override
    public String getTypeString() {
        return "nbt";
    }

    @Override
    public class_2520 toTag(boolean force) {
        if (!force) {
            throw new IncompatibleTypeException(this);
        }
        this.ensureOwnership();
        return this.getTag();
    }

    public record InventoryLocator(Object owner, class_2338 position, class_1263 inventory, int offset, boolean isEnder) {
        InventoryLocator(Object owner, class_2338 pos, class_1263 i, int o) {
            this(owner, pos, i, o, false);
        }
    }

    public static class IncompatibleTypeException
    extends RuntimeException {
        public Value val;

        private IncompatibleTypeException() {
        }

        public IncompatibleTypeException(Value val) {
            this.val = val;
        }
    }
}

